DROP PROCEDURE IF EXISTS sp_getGraficaInventario;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE sp_getGraficaInventario(
	IN p_fechaCorte DATE, IN p_isCategoria INT, IN p_isSubategoria INT, IN p_isClase INT)
BEGIN
	IF p_isCategoria = 1 THEN
		SELECT 
			CAT.idCategoria, CAT.nombre, 
            SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) AS costoTotal
		FROM PRODUCTO P
		INNER JOIN CLASE C ON C.idClase = P.idClase
		INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
		INNER JOIN CATEGORIA CAT ON CAT.idCategoria = S.idCategoria
		WHERE P.activo = 1
		GROUP BY CAT.idCategoria, CAT.nombre
        HAVING SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) > 0
		ORDER BY costoTotal DESC, CAT.nombre ASC;
    END IF;
        
	IF p_isSubategoria = 1 THEN
		SELECT 
			S.idSubcategoria, S.nombre,
			SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) AS costoTotal
		FROM PRODUCTO P
		INNER JOIN CLASE C ON C.idClase = P.idClase
		INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
		WHERE P.activo = 1
		GROUP BY S.idSubcategoria, S.nombre
        HAVING SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) > 0
		ORDER BY costoTotal DESC, S.nombre ASC;
    END IF;
        
	IF p_isClase = 1 THEN
		SELECT 
			C.idClase, C.nombre,
			SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) AS costoTotal
		FROM PRODUCTO P
		INNER JOIN CLASE C ON C.idClase = P.idClase
		WHERE P.activo = 1
		GROUP BY C.idClase, C.nombre
        HAVING SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) > 0
		ORDER BY costoTotal DESC, C.nombre ASC;
    END IF;
END
$